<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'reportbuilder', language 'en'
 *
 * @package    core_reportbuilder
 * @copyright  2020 Sara Arjona <sara@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['access'] = 'Access';
$string['actions'] = 'Actions';
$string['addaudience'] = 'Add audience \'{$a}\'';
$string['addcolumn'] = 'Add column \'{$a}\'';
$string['addusers'] = 'Add users manually';
$string['aggregatecolumn'] = 'Aggregate column \'{$a}\'';
$string['aggregationavg'] = 'Average';
$string['aggregationcount'] = 'Count';
$string['aggregationcountdistinct'] = 'Count distinct';
$string['aggregationgroupconcat'] = 'Comma separated values';
$string['aggregationgroupconcatdistinct'] = 'Comma separated distinct values';
$string['aggregationmax'] = 'Maximum';
$string['aggregationmin'] = 'Minimum';
$string['aggregationnone'] = 'No aggregation';
$string['aggregationpercent'] = 'Percentage';
$string['aggregationsum'] = 'Sum';
$string['allsiteusers'] = 'All site users';
$string['allusers'] = 'All users';
$string['apply'] = 'Apply';
$string['audience'] = 'Audience';
$string['audienceadded'] = 'Added audience \'{$a}\'';
$string['audiencecreated'] = 'Audience created';
$string['audiencedeleted'] = 'Deleted audience \'{$a}\'';
$string['audiencedeletedevent'] = 'Audience deleted';
$string['audiencelabel'] = '{$a->name}: {$a->description}';
$string['audiencemultiselectpostfix'] = '{$a->elements} plus {$a->morecount} more';
$string['audiencenotsaved'] = 'Audience not saved';
$string['audiencesaved'] = 'Audience saved';
$string['audienceupdated'] = 'Audience updated';
$string['cardview'] = 'Card view';
$string['cardview_help'] = 'Card view allows you to define the layout of your report when viewed on narrow devices. Columns will collapse beyond the limit set here, with a toggle to expand the card to view all report data.';
$string['cardviewfirstcolumntitle'] = 'First column title';
$string['cardviewsettingssaved'] = 'Card view settings saved';
$string['cardviewvisiblecolumns'] = 'Columns visible';
$string['close'] = 'Close';
$string['closeeditor'] = 'Close \'{$a}\' editor';
$string['columnadded'] = 'Added column \'{$a}\'';
$string['columnaggregated'] = 'Aggregated column \'{$a}\'';
$string['columndeleted'] = 'Deleted column \'{$a}\'';
$string['columnmoved'] = 'Moved column \'{$a}\'';
$string['columnsortdirectionasc'] = 'Sort column \'{$a}\' ascending';
$string['columnsortdirectiondesc'] = 'Sort column \'{$a}\' descending';
$string['columnsortdisable'] = 'Disable sorting for column \'{$a}\'';
$string['columnsortenable'] = 'Enable sorting for column \'{$a}\'';
$string['columnsortupdated'] = 'Updated sorting for column \'{$a}\'';
$string['conditionadded'] = 'Added condition \'{$a}\'';
$string['conditiondeleted'] = 'Deleted condition \'{$a}\'';
$string['conditionmoved'] = 'Moved condition \'{$a}\'';
$string['conditions'] = 'Conditions';
$string['conditions_help'] = 'Report conditions allow you to limit which data is displayed when the report is viewed. Users viewing the report cannot override these condition values.';
$string['conditionsapplied'] = 'Conditions applied';
$string['conditionsreset'] = 'Conditions reset';
$string['coursefullnamewithlink'] = 'Course full name with link';
$string['courseidnumberewithlink'] = 'Course ID number with link';
$string['courseshortnamewithlink'] = 'Course short name with link';
$string['courseselect'] = 'Select course';
$string['customfieldcolumn'] = '{$a}';
$string['customreports'] = 'Custom reports';
$string['deleteaudience'] = 'Delete audience \'{$a}\'';
$string['deleteaudienceconfirm'] = 'Are you sure you want to delete the audience \'{$a}\'?';
$string['deletecolumn'] = 'Delete column \'{$a}\'';
$string['deletecolumnconfirm'] = 'Are you sure you want to delete the column \'{$a}\'?';
$string['deletecondition'] = 'Delete condition \'{$a}\'';
$string['deleteconditionconfirm'] = 'Are you sure you want to delete the condition \'{$a}\'?';
$string['deletefilter'] = 'Delete filter \'{$a}\'';
$string['deletefilterconfirm'] = 'Are you sure you want to delete the filter \'{$a}\'?';
$string['deletereport'] = 'Delete report';
$string['deletereportconfirm'] = 'Are you sure you want to delete the report \'{$a}\' and all associated data?';
$string['deleteschedule'] = 'Delete schedule';
$string['deletescheduleconfirm'] = 'Are you sure you want to delete the schedule \'{$a}\'?';
$string['disableschedule'] = 'Disable schedule';
$string['editaudience'] = 'Edit audience \'{$a}\'';
$string['editdetails'] = 'Edit details';
$string['editor'] = 'Editor';
$string['editreportcontent'] = 'Edit report content';
$string['editreportdetails'] = 'Edit report details';
$string['editreportname'] = 'Edit report name';
$string['editscheduledetails'] = 'Edit schedule details';
$string['editschedulename'] = 'Edit schedule name';
$string['enablecustomreports'] = 'Enable custom reports';
$string['enablecustomreports_desc'] = 'If enabled, users can create and view Report builder custom reports.';
$string['enableschedule'] = 'Enable schedule';
$string['entitycourse'] = 'Course';
$string['entityuser'] = 'User';
$string['errorreportcreate'] = 'You cannot create a new report';
$string['errorreportedit'] = 'You cannot edit this report';
$string['errorreportview'] = 'You cannot view this report';
$string['errorsourceinvalid'] = 'Could not find valid report source';
$string['errorsourceunavailable'] = 'Report source is not available';
$string['filteradded'] = 'Added filter \'{$a}\'';
$string['filtercontains'] = 'Contains';
$string['filterdatecurrent'] = 'Current';
$string['filterdatedays'] = 'day(s)';
$string['filterdatefrom'] = 'Date from';
$string['filterdatehours'] = 'hour(s)';
$string['filterdatelast'] = 'Last';
$string['filterdateminutes'] = 'minute(s)';
$string['filterdatemonths'] = 'month(s)';
$string['filterdatenext'] = 'Next';
$string['filterdateseconds'] = 'second(s)';
$string['filterdateto'] = 'Date to';
$string['filterdateweeks'] = 'week(s)';
$string['filterdateyears'] = 'year(s)';
$string['filterdeleted'] = 'Deleted filter \'{$a}\'';
$string['filterdoesnotcontain'] = 'Does not contain';
$string['filterdurationunit'] = '{$a} unit';
$string['filterendswith'] = 'Ends with';
$string['filterequalorgreaterthan'] = 'Greater than or equal';
$string['filterequalorlessthan'] = 'Less than or equal';
$string['filterfieldoperator'] = '{$a} operator';
$string['filterfieldvalue'] = '{$a} value';
$string['filtergreaterthan'] = 'Greater than';
$string['filterinvalid'] = 'Invalid filter';
$string['filterisanyvalue'] = 'Is any value';
$string['filterisempty'] = 'Is empty';
$string['filterisequalto'] = 'Is equal to';
$string['filterisnotempty'] = 'Is not empty';
$string['filterisnotequalto'] = 'Is not equal to';
$string['filterlessthan'] = 'Less than';
$string['filtermoved'] = 'Moved filter \'{$a}\'';
$string['filterrange'] = 'Range';
$string['filtersapplied'] = 'Filters applied';
$string['filtersappliedx'] = 'Filters ({$a})';
$string['filters'] = 'Filters';
$string['filters_help'] = 'Report filters allow users viewing the report to further limit the data being displayed, by selecting their own values for each filter. Filter values are stored on a per-user basis.';
$string['filtersreset'] = 'Filters reset';
$string['filterstartswith'] = 'Starts with';
$string['hassystemrole'] = 'Assigned system role';
$string['includedefaultsetup'] = 'Include default setup';
$string['includedefaultsetup_help'] = 'Populate report with default layout as defined by the selected source. These include pre-defined columns, filters and conditions.';
$string['manuallyaddedusers'] = 'Manually added users';
$string['messagebody'] = 'Body';
$string['messagecontent'] = 'Message content';
$string['messagesubject'] = 'Subject';
$string['movecolumn'] = 'Move column \'{$a}\'';
$string['movecondition'] = 'Move condition \'{$a}\'';
$string['movefilter'] = 'Move filter \'{$a}\'';
$string['movesorting'] = 'Move sorting for column \'{$a}\'';
$string['newreport'] = 'New report';
$string['newschedule'] = 'New schedule';
$string['noaudiences'] = 'There are no audiences for this report';
$string['noconditions'] = 'There are no conditions selected';
$string['nofilters'] = 'There are no filters selected';
$string['nosortablecolumns'] = 'There are no sortable columns';
$string['or'] = 'or';
$string['privacy:metadata:audience'] = 'Report audience definitions';
$string['privacy:metadata:audience:classname'] = 'The class used by the audience';
$string['privacy:metadata:audience:configdata'] = 'Configuration data used by the audience';
$string['privacy:metadata:audience:heading'] = 'The custom heading used by the audience';
$string['privacy:metadata:audience:timecreated'] = 'The time when the audience was created';
$string['privacy:metadata:audience:timemodified'] = 'The time when the audience was last modified';
$string['privacy:metadata:audience:usercreated'] = 'The ID of the user who created the audience';
$string['privacy:metadata:audience:usermodified'] = 'The ID of the user who last modified the audience';
$string['privacy:metadata:column'] = 'Report column definitions';
$string['privacy:metadata:column:uniqueidentifier'] = 'Unique identifier of the column';
$string['privacy:metadata:column:usercreated'] = 'The ID of the user who created the column';
$string['privacy:metadata:column:usermodified'] = 'The ID of the user who last modified the column';
$string['privacy:metadata:filter'] = 'Report filter definitions';
$string['privacy:metadata:filter:uniqueidentifier'] = 'Unique identifier of the filter';
$string['privacy:metadata:filter:usercreated'] = 'The ID of the user who created the filter';
$string['privacy:metadata:filter:usermodified'] = 'The ID of the user who last modified the filter';
$string['privacy:metadata:preference:reportfilter'] = 'Stored report filter values';
$string['privacy:metadata:report'] = 'Report definitions';
$string['privacy:metadata:report:conditiondata'] = 'Configuration data for the report conditions';
$string['privacy:metadata:report:name'] = 'The name of the report';
$string['privacy:metadata:report:settingsdata'] = 'General configuration for the report';
$string['privacy:metadata:report:source'] = 'The source of the report';
$string['privacy:metadata:report:timecreated'] = 'The time when the report was created';
$string['privacy:metadata:report:timemodified'] = 'The time when the report was last modified';
$string['privacy:metadata:report:uniquerows'] = 'Whether duplicate rows are removed';
$string['privacy:metadata:report:usercreated'] = 'The ID of the user who created the report';
$string['privacy:metadata:report:usermodified'] = 'The ID of the user who last modified the report';
$string['privacy:metadata:schedule'] = 'Report schedule definitions';
$string['privacy:metadata:schedule:audiences'] = 'The audiences this schedule is for';
$string['privacy:metadata:schedule:enabled'] = 'The status of the schedule';
$string['privacy:metadata:schedule:format'] = 'The format of the scheduled report';
$string['privacy:metadata:schedule:message'] = 'The message of the schedule';
$string['privacy:metadata:schedule:name'] = 'The name of the schedule';
$string['privacy:metadata:schedule:recurrence'] = 'The recurrence of the schedule';
$string['privacy:metadata:schedule:reportempty'] = 'Action to take if scheduled report is empty';
$string['privacy:metadata:schedule:subject'] = 'The subject of the schedule';
$string['privacy:metadata:schedule:timecreated'] = 'The time when the schedule was created';
$string['privacy:metadata:schedule:timemodified'] = 'The time when the schedule was last modified';
$string['privacy:metadata:schedule:timescheduled'] = 'The time the schedule will begin';
$string['privacy:metadata:schedule:usercreated'] = 'The ID of the user who created the schedule';
$string['privacy:metadata:schedule:usermodified'] = 'The ID of the user who last modified the schedule';
$string['privacy:metadata:schedule:userviewas'] = 'The ID of the user who the schedule will be viewed as';
$string['recurrence'] = 'Recurrence';
$string['recurrenceannually'] = 'Annually';
$string['recurrencedaily'] = 'Daily';
$string['recurrencemonthly'] = 'Monthly';
$string['recurrenceweekdays'] = 'Daily (weekdays only)';
$string['recurrenceweekly'] = 'Weekly';
$string['renameaudience'] = 'Rename audience \'{$a}\'';
$string['renamecolumn'] = 'Rename column \'{$a}\'';
$string['renamefilter'] = 'Rename filter \'{$a}\'';
$string['reportbuilder'] = 'Report builder';
$string['reportcreated'] = 'Report created';
$string['reportdeleted'] = 'Report deleted';
$string['reports'] = 'Reports';
$string['reportsource'] = 'Report source';
$string['reportsource_help'] = 'The report source defines where the data for the report will come from.';
$string['reportupdated'] = 'Report updated';
$string['reportviewed'] = 'Report viewed';
$string['resetall'] = 'Reset all';
$string['resetconditions'] = 'Reset conditions';
$string['resetconditionsconfirm'] = 'Are you sure you want to reset all conditions for this report?';
$string['schedulecreated'] = 'Schedule created';
$string['scheduledeleted'] = 'Schedule deleted';
$string['scheduleempty'] = 'If the report is empty';
$string['scheduleemptydontsend'] = 'Don\'t send message';
$string['scheduleemptysendwithattachment'] = 'Send message with empty report';
$string['scheduleemptysendwithoutattachment'] = 'Send message without report';
$string['schedules'] = 'Schedules';
$string['schedulesent'] = 'Schedule sent';
$string['scheduleupdated'] = 'Schedule updated';
$string['scheduleviewas'] = 'View report data as';
$string['scheduleviewascreator'] = 'Schedule creator';
$string['scheduleviewasrecipient'] = 'Schedule recipient';
$string['selectacondition'] = 'Select a condition';
$string['selectafilter'] = 'Select a filter';
$string['selectareportsource'] = 'Select a report source';
$string['sendschedule'] = 'Send schedule';
$string['sendscheduleconfirm'] = 'Are you sure you want to queue the schedule \'{$a}\' for sending immediately?';
$string['showhide'] = 'Show/hide \'{$a}\'';
$string['showhidecard'] = 'Show/hide card';
$string['sorting'] = 'Sorting';
$string['sorting_help'] = 'Sorting defines the initial sort order of columns in the report. The order can be reversed by toggling the Up/down icon. Users can then define their own sort order by clicking on a column name.';
$string['switchedit'] = 'Switch to edit mode';
$string['switchpreview'] = 'Switch to preview mode';
$string['tasksendschedules'] = 'Send report schedules';
$string['timeadded'] = 'Time added';
$string['timecreated'] = 'Time created';
$string['timelastsent'] = 'Time last sent';
$string['timemodified'] = 'Time modified';
$string['uniquerows'] = 'Remove any duplicate rows';
$string['uniquerows_help'] = 'If the report source contains duplicate rows, should these be removed from this report? This setting has no effect if report columns are aggregated.';
$string['userany'] = 'Any user';
$string['usercurrent'] = 'Current user';
$string['userfullnamewithlink'] = 'Full name with link';
$string['userfullnamewithpicture'] = 'Full name with picture';
$string['userfullnamewithpicturelink'] = 'Full name with picture and link';
$string['usermodified'] = 'Modified by';
$string['userpicture'] = 'User picture';
$string['userselect'] = 'Select user';
$string['viewreport'] = 'View report';
